#ifndef IPHYSICALWHEELJOINT_H_
#define IPHYSICALWHEELJOINT_H_

#include "IPhysicalJoint.h"
#include "../DataTypes/DataWheelJoint.h"

namespace PhysicsEngine
{

class IPhysicalWheelJoint : public PhysicsEngine::IPhysicalJoint
{
public:
	IPhysicalWheelJoint();
	IPhysicalWheelJoint(int objectid, IPhysicalBody *body1, IPhysicalBody *body2, Vector3f axis1, Vector3f axis2, float hardness, float bounciness, float maxtorque);
	virtual ~IPhysicalWheelJoint();
	Vector3f GetAxis1();
	Vector3f GetAxis2();
	float GetHardness();
	float GetBounciness();
	float GetMaxTorque();
	void SetAxis1(Vector3f value);
	void SetAxis2(Vector3f value);
	void SetHardness(float value);
	void SetBounciness(float value);
	void SetMaxTorque(float value);
	virtual void ApplyJointVelocity(float vel)=0;
	DataJoint *GetDataJoint();
	virtual DataWheelJoint *GetDataWheelJoint()=0;
private:
	Vector3f axis1;
	Vector3f axis2;
	float hardness;
	float bounciness;
	float maxtorque;
};

}

#endif /*IPHYSICALWHEELJOINT_H_*/
